#!/usr/bin/python3

import matplotlib.pyplot as plt
import numpy as np
from scipy.optimize import minimize

def predict(xdata,params):
    """ Given a set of x values, and A, l parameters, predict the exponential decay curve)"""
    A, l = params[0],params[1]
    ypredict =  np.multiply(A, np.exp(-l*xdata))
    return ypredict

def exploss(params,xdata,ydata):
    """squared difference between measured and predicted values, for an array of data, and parameters params)"""
    diff = np.sum( (predict(xdata,params) - ydata)**2)
    return diff

def fitcurvedemo(xdata,ydata):
    """ Fit  """
    # random starting point
    start_params = np.random.uniform(0,1,size=2)
    model=predict
    # Minimize the least-squares difference between measured (ydata)
    # and predicted points calculated from xdata
    res = minimize(exploss, start_params, method='Nelder-Mead',args=(xdata,ydata))
    res.x # solution array
    return (res.x, model)


def main():

    # xpoints
    xdata = np.arange(0,10.1,0.1)
    # fake noisy data
    ydata = 40 * np.exp(-0.5* xdata) + np.random.uniform(0,1,size=len(xdata))
    # get estimated parameters using the fake data
    [estimates,model] = fitcurvedemo(xdata,ydata)
    print(estimates) # e.g. 40.1334 0.5025 (similar to 40 and 0.5 as set).
    # plot estimated values (line) v fake noisy data (points)
    fig = plt.figure()
    ax = fig.add_subplot(1, 1, 1)
    ax.scatter(xdata,ydata,c='red',label='data')
    ax.plot(xdata, model(xdata,estimates),label='fit using exponential') # plot predictions from parameters
    ax.set_title('Fitting to exponential decay')
    ax.set_xlabel('xdata')
    ax.set_ylabel('f(estimates,xdata)')
    ax.legend()
    plt.show()


if __name__ == "__main__":
    main()
