{
 "cells": [
  {
   "cell_type": "code",
   "execution_count": 10,
   "metadata": {},
   "outputs": [],
   "source": [
    "import numpy as np\n",
    "import matplotlib.pyplot as plt\n",
    "import scipy.integrate\n",
    "%matplotlib inline"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 11,
   "metadata": {},
   "outputs": [],
   "source": [
    "\n",
    "a=0.7\n",
    "b=0.6\n",
    "c=a*b\n",
    "\n",
    "p1 = (1+np.sqrt(1-4*c**2))/(2*c)\n",
    "p2 = (1-np.sqrt(1-4*c**2))/(2*c)\n",
    "\n",
    "\n",
    "X = np.arange(0,2.5,0.2)\n",
    "Y = np.arange(0,2.5,0.2)\n",
    "#https://docs.scipy.org/doc/numpy/reference/generated/numpy.meshgrid.html\n",
    "m , p = np.meshgrid(X,Y)"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 12,
   "metadata": {},
   "outputs": [],
   "source": [
    "mdot = np.divide( 1, (1+np.square(p))) - np.multiply(b,m)\n",
    "pdot = np.subtract(m, np.multiply(a,p))"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 13,
   "metadata": {},
   "outputs": [
    {
     "data": {
      "image/png": "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\n",
      "text/plain": [
       "<Figure size 432x288 with 1 Axes>"
      ]
     },
     "metadata": {
      "needs_background": "light"
     },
     "output_type": "display_data"
    }
   ],
   "source": [
    "fig, ax = plt.subplots()\n",
    "q=ax.quiver(m,p,mdot,pdot)\n",
    "ax.quiverkey(q,X=0.3,Y=2.4, U=5,\n",
    "             label='Quiver key, length = 5', labelpos='E')\n",
    "ax.plot(p,np.multiply(a,p))\n",
    "ax.plot(p, np.divide( 1, np.multiply(b,(1+np.square(p)))))\n",
    "ax.set_xlabel('p')\n",
    "ax.set_ylabel('m')\n",
    "ax.set_title('phase portrait')\n",
    "plt.show()"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 14,
   "metadata": {},
   "outputs": [],
   "source": [
    "def dydt_autoinhib(t,y,a,b):\n",
    "    y1,y2=y\n",
    "    dy1 = 1/(1+y2**2)-b*y1\n",
    "    dy2 = y1-a*y2\n",
    "    return (dy1,dy2)\n",
    "\n",
    "# lambda trick so we can pass the function with parameters into the solver\n",
    "dydt_params = lambda t,y: dydt_autoinhib(t,y,a,b)\n"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 17,
   "metadata": {},
   "outputs": [
    {
     "data": {
      "image/png": "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\n",
      "text/plain": [
       "<Figure size 432x288 with 1 Axes>"
      ]
     },
     "metadata": {
      "needs_background": "light"
     },
     "output_type": "display_data"
    }
   ],
   "source": [
    "solution1 = scipy.integrate.solve_ivp(dydt_params, t_span=(0,20),y0=(2,2), method='RK45')\n",
    "t1_ode45 = solution1.t\n",
    "m1_ode45 = solution1.y[0]\n",
    "p1_ode45 = solution1.y[1]\n",
    "\n",
    "fig, ax = plt.subplots()\n",
    "q=ax.quiver(m,p,mdot,pdot)\n",
    "ax.quiverkey(q,X=0.3,Y=2.4, U=5,\n",
    "             label='Quiver key, length = 5', labelpos='E')\n",
    "ax.plot(p,np.multiply(a,p))\n",
    "ax.plot(p, np.divide( 1, np.multiply(b,(1+np.square(p)))))\n",
    "ax.set_xlabel('p')\n",
    "ax.set_ylabel('m')\n",
    "ax.set_title('phase portrait')\n",
    "\n",
    "ax.plot(p1_ode45,m1_ode45)\n",
    "plt.show()\n",
    "\n"
   ]
  },
  {
   "cell_type": "markdown",
   "metadata": {},
   "source": [
    "\n",
    "\n"
   ]
  }
 ],
 "metadata": {
  "kernelspec": {
   "display_name": "Python 3",
   "language": "python",
   "name": "python3"
  },
  "language_info": {
   "codemirror_mode": {
    "name": "ipython",
    "version": 3
   },
   "file_extension": ".py",
   "mimetype": "text/x-python",
   "name": "python",
   "nbconvert_exporter": "python",
   "pygments_lexer": "ipython3",
   "version": "3.7.3"
  }
 },
 "nbformat": 4,
 "nbformat_minor": 2
}
