% This Matlab script allows to easily extract values from
% the simulation landscapes for values of mRNA number(s)
% and RBS strength specified within this script

close all;
clear all;

% Loading of CSV files containing considered mRNA amounts and RBS strengths
mRNA_amount = csvread('mRNA_amount.csv');
RBS_strength = csvread('RBS_str.csv');

% Loading of CSV files created from the Python simulations
Circuit_Output = csvread('circuit_out.csv');
Monitor_Output = csvread('monitor_out.csv');

% Extraction of the values of Circuit_Output and Monitor_Output for given mRNA_amounts and
% RBS_strength

mRNA_values = [3000]; % This contains the values of mRNA numbers specified by the user
RBS_values = [6, 2]; % This contains the values of RBS strengths specified by the user
mRNA_RBS_values = [
    mRNA_values(1),RBS_values(1);
    mRNA_values(1),RBS_values(2)
    ];

RBS_indices = [
    find(RBS_strength == RBS_values(1));
    find(RBS_strength == RBS_values(2))
    ];

mRNA_indices = [
    find(mRNA_amount == mRNA_values(1))
    ];

Circuit_Output_Values = [
    Circuit_Output(RBS_indices(1),mRNA_indices(1));
    Circuit_Output(RBS_indices(2),mRNA_indices(1))
    ];

Monitor_Output_Values = [
    Monitor_Output(RBS_indices(1),mRNA_indices(1));
    Monitor_Output(RBS_indices(2),mRNA_indices(1))
    ];

Table = [mRNA_RBS_values, Circuit_Output_Values, Monitor_Output_Values];
Headers = {'mRNAs', 'RBS_strength', 'Circuit_Output', 'Monitor_Output'};
csvwrite_with_headers('Circuit_Monitor_Values_Long_Sequence_Fast_Codon.csv',Table,Headers);