% Copyright (c) 2015, R. Algar,  F. Ceroni, T. Ellis, G.-B. Stan
% All rights reserved.

% Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

% 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

% 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


close all;
clear all;

% Loading of CSV files containing considered mRNA amounts and RBS strengths
mRNA_amount = csvread('mRNA_amount.csv');
RBS_strength = csvread('RBS_str.csv');

% Loading of CSV files created from the Python simulations
Circuit_Output = csvread('circuit_out.csv');

% Setting the range for the colourmaps
min_colormap = 0;
max_colormap = 90;

% Representation of data in 3D or heatmap format
[X,Y] = meshgrid(mRNA_amount,RBS_strength);
f_1=figure(1);
contourf(X,Y,Circuit_Output,15);
shading interp    % interpolate the colormap across the surface face
colormap('jet');
colormap(flipud(colormap)); % To inverse the colormap
h = colorbar;
caxis([min_colormap max_colormap]);
set(gca,'FontSize',18);
ylabel(h, 'Simulated Circuit Output','FontSize',18);
% title('Short Sequence, Slow Codons');
xlabel('mRNA amount','FontSize',18);
ylabel('RBS strength','FontSize',18);
% Saving the graph in PDF
saveas(f_1,'Heat_Map_Circuit_Output_Long_Sequence_Slow_Codons','pdf')
