#!/usr/bin/python
# Copyright (c) 2015, R. Algar,  F. Ceroni, T. Ellis, G.-B. Stan
# All rights reserved.

# Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

# 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

# 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import os
import sys

import numpy as np
import xml.etree.ElementTree as ET

from models import Cell, Circuit
from simulations import simulate_landscape

# Get parameters from XML file

print 'Number of arguments:', len(sys.argv), 'arguments.'
print 'Argument List:', str(sys.argv)

file_location = sys.argv[1]

tree = ET.parse(file_location)
root = tree.getroot()

total_ribosomes = int(root.find('cell').find('total_ribosomes').text)

monitor_el = root.find('monitor')

monitor_mrna = int(monitor_el.find('mrna_number').text)
monitor_rbs = float(monitor_el.find('rbs_strength').text)
monitor_betas = [float(x) for x in monitor_el.find('betas').text.split(',')]
monitor_ap_scale = float(monitor_el.find('alpha_plus_scale').text)
monitor_am_scale = float(monitor_el.find('alpha_minus_scale').text)

monitor = Circuit(monitor_mrna, monitor_ap_scale, monitor_am_scale, None, monitor_betas, monitor_rbs)

circuit_el = root.find('circuit')

rbs_range = int(circuit_el.find('rbs_strength_steps').text)
rbs_step = float(circuit_el.find('rbs_strength_step').text)
mrna_range = int(circuit_el.find('mrna_number_steps').text)
mrna_step = float(circuit_el.find('mrna_number_step').text)

circuit_betas = [float(x) for x in circuit_el.find('betas').text.split(',')]
circuit_ap_scale = float(circuit_el.find('alpha_plus_scale').text)
circuit_am_scale = float(circuit_el.find('alpha_minus_scale').text)

circuit = Circuit(mrna_step, circuit_ap_scale, circuit_am_scale, None, circuit_betas, rbs_step)

# Define parameters for simulation

#total_ribosomes = 10000
#rbs_step = circuit_rbs_step
#rbs_range = 100
#mrna_step = 100
#mrna_range = 50
#slow_codons = False

mRNA_amount = np.arange(1, mrna_range+1, 1)
RBS_str = np.arange(1, rbs_range+1, 1)

mRNA_amount *= mrna_step
RBS_str = RBS_str * rbs_step

res = simulate_landscape(monitor, circuit, rbs_range, mrna_range, rbs_step, mrna_step, True)

# Set directory loaction

directory = "./data/"+root.find('simulation_name').text

# Check if director exists and create if not

if not os.path.exists(directory):
    os.makedirs(directory)

# Save all arrays in .csv files	
np.savetxt(directory+"/RBS_str.csv", RBS_str, delimiter=",")
np.savetxt(directory+"/mRNA_amount.csv", mRNA_amount, delimiter=",")
np.savetxt(directory+"/monitor_out.csv", res['monitor_out'], delimiter=",")
np.savetxt(directory+"/circuit_out.csv", res['circuit_out'], delimiter=",")
np.savetxt(directory+"/circuit_ribs.csv", res['circuit_ribs'], delimiter=",")
np.savetxt(directory+"/monitor_ribs.csv", res['monitor_ribs'], delimiter=",")
np.savetxt(directory+"/free_ribs.csv", res['free_ribs'], delimiter=",")
np.savetxt(directory+"/success_code.csv", res['success_code'], delimiter=",")