# Copyright (c) 2015, R. Algar,  F. Ceroni, T. Ellis, G.-B. Stan
# All rights reserved.

# Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

# 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

# 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import numpy as np
from models import Cell, Circuit


class SimulationResult(object):
    def __init__(self, results_dict, circuit, monitor=None, cell=None):
        self.results_dict = results_dict
        self.monitor_dist = results_dict['circuits'][0]
        self.circuit_dist = results_dict['circuits'][1]
        self.free_ribs = results_dict['free_ribosomes']
        #self.circuit = circuit
        #self.monitor = monitor
        #self.cell = cell
        self.monitor_output = self.monitor_dist[-1] * monitor.betas[-1]
        self.circuit_output = self.circuit_dist[-1] * circuit.betas[-1]
        if results_dict.has_key('success_code'):
            self.success_code = results_dict['success_code']
        else:
            self.success_code = []


def simulate_landscape(monitor, circuit, rbs_range=20, mrna_range=15, rbs_steps=0.1, mrna_steps=100, previous_ic=True):
    monitor_out = np.zeros([rbs_range,mrna_range])
    circuit_out = np.zeros([rbs_range,mrna_range])
    monitor_ribs = np.zeros([rbs_range,mrna_range])
    circuit_ribs = np.zeros([rbs_range,mrna_range])
    free_ribs = np.zeros([rbs_range,mrna_range])
    rbs_str = np.zeros([rbs_range,mrna_range])
    mrna_num = np.zeros([rbs_range,mrna_range])
    success_code = np.zeros([rbs_range,mrna_range])
    #betas = [1 for i in range(100)]
    # Use default initial conditions for first run
    ic = []
    #if slow_codons:
    #    for i in range(79,90):
    #        betas[i] = 0.5*betas[i]
    # Iterate over RBS inside the mRNA loop
    for j in range(mrna_range):
        for i in range(rbs_range):
            if i == 0:
                ic = []
            rbs_strength = rbs_steps*(i+1)
            mrna_abundance = mrna_steps*(j+1)
            sim_circuit = Circuit(mrna_abundance, circuit.ap_scale, circuit.am_scale, None, circuit.input_betas, rbs_strength)
            cell = Cell(10000, [monitor, sim_circuit])
            res, sol = cell.simulate(ic)
            if previous_ic == False:
                ic = []
            else:
                ic = sol
            result = SimulationResult(res, sim_circuit, monitor, cell)
            print 'RBS:', (i+1)*rbs_steps, 'mRNA:', (j+1)*mrna_steps
            circuit_out[i,j] = result.circuit_output
            monitor_out[i,j] = result.monitor_output
            circuit_ribs[i,j] = sum(result.circuit_dist)
            monitor_ribs[i,j] = sum(result.monitor_dist)
            free_ribs[i,j] = result.free_ribs
            rbs_str[i,j] = rbs_strength
            mrna_num[i,j] = mrna_abundance
            print result.free_ribs, result.circuit_output
            success_code[i,j] = int(result.success_code)
            #sim_results[i][j] = [{
            #    'rbs_strength': rbs_strength,
            #    'mrna_abundance': mrna_abundance,
            #    'circuit': circuit,
            #    'monitor': monitor,
            #    'result': result
            #}]

    return {'circuit_out': circuit_out, 'monitor_out': monitor_out, 'circuit_ribs': circuit_ribs,
            'monitor_ribs': monitor_ribs, 'free_ribs': free_ribs, 'mrna_num': mrna_num, 'rbs_str': rbs_str,
            'success_code': success_code}

